/**
 * @fileOverview 登录前菜单相关的逻辑
 * @author luangong@tencent.com
 * @version 1.0 
 */

$(function() {
    menu.init();
});

var menu = {};

/**
 * 从 URL 的 GET 参数中取得菜单 ID
 * @returns {number} 菜单的 ID
 */
menu.getId = function() {
    return parseInt(qqbrowser.js.logic.utils.parseUrl().id, 10);
};

/**
 * 初始化菜单
 */
menu.init = function() {
    var menuId = menu.getId();
    qqbrowser.skin.menu.init(menuId, function(retval) {
        var menuData = {};
        if (retval) {
            menuData = JSON.parse(retval, function(key, value) {
                return typeof(value) == 'string' ? unescape(value) : value;
            });
        }
        menu.build(menuData);
    });
};

/**
 * 构造菜单
 * @param {Array} data
 */
menu.build = function(data) {

    var menuData = data[1];
    var menuParams = data[2];
    var menuId = menu.getId();
    var menuElement = $('#before-menu-inner');
    var menuHTML = '';

    // 构造菜单
    for (var i = 0; i < menuData.length; i++) {
        var menuItem = menuData[i];
        var menuItemName = menuItem.name;

        // id: 每一菜单项的id
        // type：类型
        // enabled: 是否激活
        // checked: 是否选定
        // name: 名称
        // subMenuId: 子菜单id
        // icon: 图标

        // 分隔符的处理
        /*
        if (menuItem.type == 2) {
            menuUlHTML += '<li class="hr"></li>';
            continue;
        }
        */

        // var menuItemId = JSON.stringify(menuItem.id);
        var liStyle = menuItem.checked == 1 ? ' class="selected"' : '';

        // 父文件夹处理
        /*
        if (menuItem.subMenuId) {
            liStyle = ' class="parent" submenuid="' + menuItem.subMenuId + '"';
        }
        */

        // 状态
        if (!menuItem.enabled)
            liStyle = ' class="disabled"';

        menuHTML += 
            '<div' + liStyle + '>' +
                menuItemName +
            '</div>';

        // 点击执行菜单点击操作
        $('#before-menu-inner').click(function() {
            qqbrowser.skin.menu.click(menuId, menuItem.id, menuParams);
        });
    }
    menuElement.html(menuHTML);
    var menuSize = qqbrowser.js.logic.viewManager.getSize('before-menu-layer');
    qqbrowser.skin.menu.show(menuId, menuSize.width, menuSize.height);
};

/**
 * 针对 border + box shadow 提供统一解决方案
 */
/*
function getSize(elementName) {
    var element = typeof elementName == 'string' ? $('#' + elementName) : elementName; // 可以直接传递 jQuery 对象
    var innerHeight = element.outerHeight();
    var innerWidth = element.outerWidth();

    // 计算 box shadow 的高度
    var elementShadow = element.css('-webkit-box-shadow');
    var regex = /(\dpx)\s(\dpx)\s(\dpx)/;

    var elementShadowOffsetX = elementShadowOffsetY = elementSize = 0;

    if (regex.test(elementShadow)) {
        elementShadowOffsetX = fromPx2Int(RegExp["$1"]);
        elementShadowOffsetY = fromPx2Int(RegExp["$2"]);
        elementSize = fromPx2Int(RegExp["$3"]);
    }

    return {
        width:  innerWidth  + elementShadowOffsetX + elementSize,
        height: innerHeight + elementShadowOffsetY + elementSize
    };
};
*/

/**
 * 从 css 的 px 值中得到数字
 */
/*
function fromPx2Int(text) {
    if (!text) {
        return 0;
    } else {
        return parseInt(text.replace("px", ""), 10);
    }
};
*/

/**
 * 分析 URL 的 GET 参数
 * @returns {Object} 表示 GET 参数的关联数组（map）
 */
/*
function parseUrl() {
    var url = location.href;
    var item = [];
    var result = {};
    var query = url.substr(url.indexOf("?") + 1);
    var tmp = query.split("&");

    for (var i = 0; i < tmp.length; i++) {
        item = tmp[i].split("=");
        result[item[0]] = item[1];
    }
    return result;
};
*/
